/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.StoredSearch;
import com.filenet.wcm.api.VersionSeries;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWIDMTridentLibrary;
import filenet.vw.idm.trident.VWTridentFactoryProperties;

class VWIDMTridentStoredSearch
extends VWIDMTridentItem {
    StoredSearch m_search = null;
    VersionSeries m_versionSeries = null;
    private static final String m_className = "VWIDMTridentStoredSearch";
    boolean m_useCurrentVersion = false;
    private String[] m_currentUser = null;

    private boolean checkCurrentUser(String user) {
        if (user == null) {
            return false;
        }
        int nUserNames = this.m_currentUser == null ? 0 : this.m_currentUser.length;
        for (int i = 0; i < nUserNames; ++i) {
            if (!user.equals(this.m_currentUser[i])) continue;
            return true;
        }
        return false;
    }

    private void getProps() {
        String m_method = "getProps:";
        try {
            if (this.m_versionSeries == null) {
                this.m_versionSeries = (VersionSeries)this.getProp("VersionSeries");
            }
            this.m_currentUser = ((VWTridentFactoryProperties)VWIDMBaseFactory.instance().getProperties()).getCurrentUser();
            logger.fine(m_className, m_method, "Current User =" + Logger.asString(this.m_currentUser) + ", VersionSeries =" + this.m_versionSeries.getId() + ", libId=" + this.m_lib.getId());
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method + this.getId(), e);
        }
    }

    protected VWIDMTridentStoredSearch(StoredSearch search, VWIDMTridentLibrary lib) {
        String m_method = "CTOR 2 (from dialog)";
        this.m_wcmObject = search;
        if (this.m_wcmObject == null) {
            logger.warning(m_className, m_method, "No WcmObject 1!");
            return;
        }
        this.m_search = search;
        this.m_lib = lib;
        this.getProps();
    }

    protected VWIDMTridentStoredSearch(StoredSearch search, VWIDMTridentLibrary lib, WcmDlgItem dlgItem) {
        String m_method = "CTOR 3, with VersionSeries";
        this.m_wcmObject = search;
        if (this.m_wcmObject == null) {
            logger.warning(m_className, m_method, "No WcmObject 1!");
            return;
        }
        this.m_search = search;
        this.m_lib = lib;
        this.m_dlgItem = dlgItem;
        this.getProps();
        this.m_useCurrentVersion = this.isCurrentVersion();
    }

    private boolean isCurrentVersion() {
        try {
            return (Boolean)this.getProp("IsCurrentVersion");
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected VWIDMTridentStoredSearch(VersionSeries versionSeries, StoredSearch srch, VWIDMTridentLibrary lib) {
        String m_method = "CTOR 3, with VersionSeries";
        if (versionSeries == null) {
            logger.warning(m_className, m_method, "No WcmObject for VersionSeries!!");
            return;
        }
        this.m_versionSeries = versionSeries;
        if (srch == null) {
            srch = (StoredSearch)this.m_versionSeries.getCurrentVersion();
            this.m_useCurrentVersion = true;
        }
        this.m_wcmObject = srch;
        this.m_lib = lib;
        logger.fine(m_className, m_method, this.getId() + ", useCurrentVersion=" + new Boolean(this.m_useCurrentVersion).toString());
        this.getProps();
    }

    public String getLibraryId() {
        return this.m_lib.getId();
    }

    public String getLibraryLabel() {
        return this.m_lib.getLabel();
    }

    public String getCanonicalName() {
        String m_method = "getCanonicalName";
        String id = this.m_versionSeries != null ? this.m_versionSeries.getId() : "";
        String version = this.m_useCurrentVersion ? "" : this.getId();
        String res = Integer.toString(4) + ":" + this.m_lib.toString() + ":" + id + ":" + version;
        logger.fine(m_className, m_method, "returns=" + res);
        return res;
    }

    public IVWIDMItem[] list(boolean dirOnly) throws VWException {
        throw new VWException("idm.trident.IDMTridentStoredSearch.InvalidFunction", "Invalid function.");
    }

    public Object getProp(String propName) throws VWException {
        if (this.m_search == null) {
            throw new VWException("idm.trident.IDMTridentStoredSearch.getProp1", "No object is available.");
        }
        String m_method = "getProp:" + propName;
        try {
            Property prop;
            Object retVal = null;
            Properties props = this.m_search.getProperties(new String[]{propName});
            if (props != null && (prop = (Property)props.get(0)) != null) {
                retVal = VWIDMTridentStoredSearch.mapGetPropertyValue(prop.getValue(), propName, prop);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "value=" + (retVal == null ? "NULL" : retVal.toString()));
            }
            return retVal;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentStoredSearch.getProp2", "Failed to get property {0}.  {1}", propName, e.getMessage());
        }
    }

    public void save() throws VWException {
        Properties propsToSave = this.getSaveProperties();
        if (propsToSave != null) {
            try {
                this.m_search.setProperties(propsToSave);
            }
            catch (Exception e) {
                logger.throwing(m_className, "save:" + this.getId(), e);
            }
        }
    }

    public int getType() {
        return 4;
    }

    public static Object getProp(StoredSearch search, String propName) throws VWException {
        if (search == null) {
            throw new VWException("idm.trident.IDMTridentStoredSearch.getProp1", "No object is available.");
        }
        String m_method = "getProp:" + propName + ":" + search.getName();
        try {
            Property prop;
            Object retVal = null;
            Properties props = search.getProperties(new String[]{propName});
            if (props != null && (prop = (Property)props.get(0)) != null) {
                retVal = VWIDMTridentItem.mapGetPropertyValue(prop.getValue(), propName, prop);
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "value=" + (retVal == null ? "NULL" : retVal.toString()));
            }
            return retVal;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.IDMTridentStoredSearch.getProp2", "Failed to get property {0}.  {1}", propName, e.getMessage());
        }
    }

    public String getVersionId() {
        if (this.m_useCurrentVersion) {
            return null;
        }
        return this.getId();
    }

    public VWAttachment getVWAttachment() throws VWException {
        String m_method = "getVWAttachment";
        VWAttachment ret = new VWAttachment();
        ret.setType(this.getType());
        ret.setLibraryType(this.getLibraryType());
        ret.setLibraryName(this.getLibraryLabel());
        ret.setId(this.m_versionSeries != null ? this.m_versionSeries.getId() : null);
        ret.setVersion(this.getVersionId());
        ret.setAttachmentName(this.getLabel());
        logger.fine(m_className, m_method, "returns " + ret.toString());
        return ret;
    }

    public String getVersionSeriesId() {
        if (this.m_versionSeries != null) {
            return this.m_versionSeries.getId();
        }
        return null;
    }

    protected void initContents() throws VWException {
        throw new VWException("idm.trident.notImplemented", "Not implemented.");
    }
}

